/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.ipm.api.failover;

import cz.integsoft.mule.ipm.api.failover.FailoverGroup;
import cz.integsoft.mule.ipm.api.failover.FailoverHost;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.TypeDsl;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@Alias(value="address-failover-group")
@TypeDsl(allowTopLevelDefinition=true, allowInlineDefinition=true)
public class DefaultFailoverGroup
implements FailoverGroup<FailoverHost> {
    @Alias(value="failover-hosts")
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="Set of hosts to use for failover")
    private final Set<FailoverHost> hosts = Collections.synchronizedSet(new HashSet());

    @Override
    public List<FailoverHost> getHosts() {
        return new ArrayList<FailoverHost>(this.hosts);
    }

    @Override
    public int size() {
        return this.hosts.size();
    }

    @Override
    public void add(FailoverHost failoverHost) {
        if (failoverHost != null) {
            this.hosts.add(failoverHost);
        }
    }

    @Override
    public FailoverHost remove(FailoverHost failoverHost) {
        if (failoverHost == null) {
            return null;
        }
        boolean bl = this.hosts.remove(failoverHost);
        return bl ? failoverHost : null;
    }

    @Override
    public FailoverHost get(String string, int n) {
        if (string != null) {
            Optional<FailoverHost> optional = this.hosts.stream().filter(failoverHost -> failoverHost.getHostname().equals(string) && failoverHost.getPort() == n).findFirst();
            return optional.orElse(null);
        }
        return null;
    }
}

