/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.ipm.api.failover;

import java.util.Objects;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.TypeDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@Alias(value="host")
@TypeDsl(allowInlineDefinition=true, allowTopLevelDefinition=false)
public class FailoverHost {
    @Parameter
    @Placement(order=1, tab="Connection")
    @Summary(value="Host DNS or IP address")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String hostname;
    @Parameter
    @Placement(order=2, tab="Connection")
    @Summary(value="Port number")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private int port;
    @Parameter
    @Optional
    @Placement(order=1, tab="TLS")
    @Summary(value="User name for authentication")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String username;
    @Parameter
    @Optional
    @Placement(order=2, tab="TLS")
    @Summary(value="Password for authentication")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Password
    private String password;

    public FailoverHost() {
    }

    public FailoverHost(String string, int n) {
        this(string, n, null, null);
    }

    public FailoverHost(String string, int n, String string2, String string3) {
        this.hostname = string;
        this.port = n;
        this.username = string2;
        this.password = string3;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.port);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FailoverHost failoverHost = (FailoverHost)object;
        return Objects.equals(this.hostname, failoverHost.hostname) && this.port == failoverHost.port;
    }

    public String getId() {
        return this.hostname + ":" + this.port;
    }

    public String getAddress() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!StringUtils.isBlank((String)this.username)) {
            stringBuilder.append(this.username);
            if (!StringUtils.isBlank((String)this.password)) {
                stringBuilder.append(":").append(this.password);
            }
            stringBuilder.append("@");
        }
        stringBuilder.append(this.hostname).append(":").append(this.port);
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("FailoverHost [hostname=");
        stringBuilder.append(this.hostname);
        stringBuilder.append(", port=");
        stringBuilder.append(this.port);
        stringBuilder.append(", username=");
        stringBuilder.append(this.username);
        stringBuilder.append(", password=");
        stringBuilder.append("*****");
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

