/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.ipm.internal.socket.parameter;

import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public abstract class AbstractSocketRequestParameter {
    private static final int cc = 0;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Summary(value="Outbound address, e.g. tcp://host:port")
    @Alias(value="address", description="Outbound address. Can be expression.")
    private String bN;
    @Parameter
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="Enables one-way (just) send data if true. Default is false.")
    @Alias(value="one-way", description="Boolean value")
    private boolean cd;
    @Parameter
    @Optional(defaultValue="8192")
    @Summary(value="Reading buffer size. Default is 8192 bytes.")
    @Alias(value="read-buffer-size")
    private int ce;

    public String getAddress() {
        return this.bN;
    }

    public boolean al() {
        return this.cd;
    }

    public int am() {
        return this.ce;
    }

    public InetSocketAddress getInetSocketAddress() {
        URI uRI;
        try {
            uRI = new URI(this.bN);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
        int n = uRI.getPort();
        String string = uRI.getHost();
        if (StringUtils.isBlank((String)string) && n == -1) {
            return new InetSocketAddress(0);
        }
        if (n == -1 && !StringUtils.isBlank((String)string)) {
            return new InetSocketAddress(string, 0);
        }
        if (n > 0 && StringUtils.isBlank((String)string)) {
            return new InetSocketAddress(n);
        }
        return new InetSocketAddress(string, n);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AbstractSocketRequestParameter [address=");
        stringBuilder.append(this.bN);
        stringBuilder.append(", oneWay=");
        stringBuilder.append(this.cd);
        stringBuilder.append(", readBufferSize=");
        stringBuilder.append(this.ce);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

