/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.ipm.internal.http.operation;

import cz.integsoft.mule.ipm.api.ProxyErrorCode;
import cz.integsoft.mule.ipm.api.exception.ProcessingException;
import cz.integsoft.mule.ipm.api.exception.ReadTimeoutException;
import cz.integsoft.mule.ipm.api.http.HttpSendBodyMode;
import cz.integsoft.mule.ipm.api.http.HttpStreamingType;
import cz.integsoft.mule.ipm.api.http.ProxyHttpResponseAttributes;
import cz.integsoft.mule.ipm.api.http.authentication.HttpRequestAuthentication;
import cz.integsoft.mule.ipm.api.http.parameter.UriParameters;
import cz.integsoft.mule.ipm.api.http.proxy.ViaHttpProxyConfig;
import cz.integsoft.mule.ipm.internal.http.HttpExtensionClient;
import cz.integsoft.mule.ipm.internal.http.OffsetCursorProviderWrapper;
import cz.integsoft.mule.ipm.internal.http.config.HttpProxyConfig;
import cz.integsoft.mule.ipm.internal.http.parameter.ExclusiveHttpHeaders;
import cz.integsoft.mule.ipm.internal.http.parameter.HttpRequestParameter;
import cz.integsoft.mule.ipm.internal.http.parameter.KeyStoreMappingHolder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.net.ssl.SSLException;
import org.apache.commons.lang3.StringUtils;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextFactoryBuilder;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProxyOperationDelegate {
    private static final int bs = 80;
    private static final int bt = 443;
    private static final Charset bu = Charset.defaultCharset();
    private static final Logger bv = LoggerFactory.getLogger(HttpProxyOperationDelegate.class);
    private static final Logger bw = LoggerFactory.getLogger((String)"IPM_HTTP_WIRE_LOG");
    private static final String bx = "ipm.requester.%s";
    private static final Set<String> by = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("GET", "HEAD", "OPTIONS")));
    private static final String bz = "Cannot send both Transfer-Encoding and Content-Length headers. Transfer-Encoding will not be sent.";
    private static final String bA = "Transfer-Encoding header will not be sent, as the configured requestStreamingMode is NEVER.";
    private static final String bB = "Transfer-Encoding header value was invalid and will not be sent.";
    private static final String bC = "Cookie".toLowerCase();
    private static final String bD = "; ";
    private static final String bE = "Remotely closed";
    private static final String bF = "SSLEngine is CLOSED";

    public void a(TypedValue<?> typedValue, ExclusiveHttpHeaders exclusiveHttpHeaders, HttpRequestParameter httpRequestParameter, HttpRequestAttributes httpRequestAttributes, HttpExtensionClient httpExtensionClient, URI uRI, HttpProxyConfig httpProxyConfig, CompletionCallback<InputStream, ProxyHttpResponseAttributes> completionCallback, StreamingHelper streamingHelper, HttpSendBodyMode httpSendBodyMode, HttpStreamingType httpStreamingType, TransformationService transformationService, int n) throws IOException {
        HttpRequest httpRequest = this.a(typedValue, exclusiveHttpHeaders, httpRequestParameter, httpRequestAttributes, uRI, httpProxyConfig, httpSendBodyMode, httpStreamingType, transformationService);
        httpExtensionClient.a(httpRequest, httpRequestParameter.ad() == null ? httpProxyConfig.I().j() : httpRequestParameter.ad(), httpProxyConfig.K(), this.a(httpExtensionClient.w()), httpSendBodyMode).whenComplete((httpResponse, throwable) -> {
            block22: {
                try {
                    if (httpResponse != null) {
                        if (httpProxyConfig.J()) {
                            this.a(httpProxyConfig, (HttpResponse)httpResponse, uRI);
                        }
                        try {
                            HttpEntity httpEntity = httpResponse.getEntity();
                            Supplier<InputStream> supplier = this.a(streamingHelper, httpEntity);
                            String string = httpResponse.getHeaderValue("Content-Type");
                            int n2 = httpResponse.getStatusCode();
                            ProxyHttpResponseAttributes proxyHttpResponseAttributes = new ProxyHttpResponseAttributes(n2, httpResponse.getReasonPhrase(), (MultiMap<String, String>)httpResponse.getHeaders(), httpRequest.getMethod(), uRI.toString(), (MultiMap<String, String>)httpRequest.getHeaders());
                            if (httpEntity != null && !(httpEntity instanceof EmptyHttpEntity)) {
                                bv.debug("Got response entity: {} isStreaming: {}", (Object)httpEntity, (Object)httpEntity.isStreaming());
                                completionCallback.success(Result.builder().output((Object)supplier.get()).attributes((Object)proxyHttpResponseAttributes).mediaType(string == null ? MediaType.ANY : MediaType.parse((String)string)).build());
                                break block22;
                            }
                            bv.debug("Entity is null");
                            completionCallback.success(Result.builder().attributes((Object)proxyHttpResponseAttributes).mediaType(string == null ? MediaType.ANY : MediaType.parse((String)string)).build());
                        }
                        catch (Exception exception) {
                            completionCallback.error((Throwable)((Object)new ProcessingException(ProxyErrorCode.IPM_SND_003, "Error occurred while processing http response from " + httpRequestParameter.getAddress() + ": " + throwable.getLocalizedMessage(), (Throwable)throwable)));
                        }
                        break block22;
                    }
                    this.a((Throwable)throwable, httpExtensionClient.v());
                    if (this.a((Throwable)throwable, n, httpRequest)) {
                        this.a(typedValue, exclusiveHttpHeaders, httpRequestParameter, httpRequestAttributes, httpExtensionClient, uRI, httpProxyConfig, completionCallback, streamingHelper, httpSendBodyMode, httpStreamingType, transformationService, n - 1);
                        return;
                    }
                    if (throwable instanceof TimeoutException) {
                        completionCallback.error((Throwable)((Object)new ReadTimeoutException(ProxyErrorCode.IPM_SND_002, "Read timeout occurred while sending http request to " + httpRequestParameter.getAddress() + ": " + throwable.getLocalizedMessage(), (Throwable)throwable)));
                    } else {
                        completionCallback.error((Throwable)((Object)new ProcessingException(ProxyErrorCode.IPM_SND_003, "Error occurred while sending http request to " + httpRequestParameter.getAddress() + ": " + throwable.getLocalizedMessage(), (Throwable)throwable)));
                    }
                }
                catch (Exception exception) {
                    completionCallback.error((Throwable)((Object)new ProcessingException(ProxyErrorCode.IPM_SND_007, "Error occurred while processing http response from " + httpRequestParameter.getAddress() + ": " + throwable.getLocalizedMessage(), (Throwable)throwable)));
                }
                finally {
                    try {
                        httpExtensionClient.stop();
                    }
                    catch (MuleException muleException) {
                        bv.warn("Found exception trying to stop http client: " + muleException.getMessage(), (Throwable)muleException);
                    }
                }
            }
        });
    }

    private boolean a(Throwable throwable, int n, HttpRequest httpRequest) {
        boolean bl;
        boolean bl2 = bl = !(!(throwable instanceof IOException) && !(throwable instanceof SSLException) || !StringUtils.containsIgnoreCase((CharSequence)throwable.getMessage(), (CharSequence)bE) && !StringUtils.containsIgnoreCase((CharSequence)throwable.getMessage(), (CharSequence)bF) || !this.j(httpRequest.getMethod()) || n <= 0);
        if (bl) {
            boolean bl3 = this.a(httpRequest);
            if (bl3) {
                bv.warn("Sending HTTP message failed with {}: {}. Request will be retried {} time(s) before failing." + throwable.getClass().getName(), (Object)throwable.getMessage(), (Object)n);
            } else {
                bv.warn("Sending HTTP message failed with {}: {}. Request will not be retried because entity not support retry." + throwable.getClass().getName(), (Object)throwable.getMessage());
                bl = false;
            }
        }
        return bl;
    }

    private boolean j(String string) {
        return true;
    }

    private boolean a(HttpRequest httpRequest) {
        boolean bl = true;
        if (httpRequest.getEntity() != null && httpRequest.getEntity().isStreaming()) {
            bl = httpRequest.getEntity().getContent().markSupported();
        }
        return bl;
    }

    private HttpRequest a(TypedValue<?> typedValue, ExclusiveHttpHeaders exclusiveHttpHeaders, HttpRequestParameter httpRequestParameter, HttpRequestAttributes httpRequestAttributes, URI uRI, HttpProxyConfig httpProxyConfig, HttpSendBodyMode httpSendBodyMode, HttpStreamingType httpStreamingType, TransformationService transformationService) throws IOException {
        String string = StringUtils.isBlank((CharSequence)httpRequestParameter.Z()) ? httpRequestAttributes.getMethod() : httpRequestParameter.Z();
        HttpRequestBuilder httpRequestBuilder = HttpRequest.builder();
        httpRequestBuilder.uri(uRI).method(string);
        httpRequestParameter.Y().entrySet().forEach(entry -> {
            bv.debug("Adding query parameter {}:{}", entry.getKey(), entry.getValue());
            httpRequestBuilder.addQueryParam((String)entry.getKey(), (String)entry.getValue());
        });
        exclusiveHttpHeaders.W().forEach(httpHeader -> {
            if (StringUtils.isNotBlank((CharSequence)httpHeader.getValue())) {
                bv.debug("Adding request header {}:{}", (Object)httpHeader.getKey(), (Object)httpHeader.getValue());
                httpRequestBuilder.addHeader(httpHeader.getKey(), httpHeader.getValue());
            }
        });
        exclusiveHttpHeaders.X().entrySet().forEach(entry -> {
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) {
                bv.debug("Adding dynamic request header {}:{}", entry.getKey(), entry.getValue());
                httpRequestBuilder.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        });
        if (httpProxyConfig.J()) {
            this.a(httpProxyConfig, uRI, httpRequestBuilder);
        }
        httpRequestBuilder.entity(this.a(httpRequestBuilder, typedValue, exclusiveHttpHeaders, string, httpSendBodyMode, httpStreamingType, transformationService));
        return httpRequestBuilder.build();
    }

    private void a(HttpProxyConfig httpProxyConfig, URI uRI, HttpRequestBuilder httpRequestBuilder) {
        try {
            List<String> list = httpProxyConfig.E().get(httpRequestBuilder.getUri(), Collections.emptyMap()).get("Cookie");
            if (list != null && list.size() > 0) {
                int n = bD.length() * (list.size() - 1);
                for (String string : list) {
                    n += string.length();
                }
                StringBuilder stringBuilder = new StringBuilder(n).append(list.get(0));
                for (int i = 1; i < list.size(); ++i) {
                    stringBuilder.append(bD).append(list.get(i));
                }
                httpRequestBuilder.addHeader(bC, stringBuilder.toString());
            }
        }
        catch (IOException iOException) {
            bv.warn("Error reading cookies for URI " + uRI, (Throwable)iOException);
        }
    }

    private void a(HttpProxyConfig httpProxyConfig, HttpResponse httpResponse, URI uRI) {
        Collection collection = httpResponse.getHeaderValues("Set-Cookie");
        Collection collection2 = httpResponse.getHeaderValues("Set-Cookie2");
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        if (collection != null) {
            hashMap.put("Set-Cookie", new ArrayList(collection));
        }
        if (collection2 != null) {
            hashMap.put("Set-Cookie2", new ArrayList(collection2));
        }
        try {
            httpProxyConfig.E().put(uRI, hashMap);
        }
        catch (IOException iOException) {
            bv.warn("Error storing cookies for URI " + uRI, (Throwable)iOException);
        }
    }

    HttpEntity a(HttpRequestBuilder httpRequestBuilder, TypedValue<?> typedValue, ExclusiveHttpHeaders exclusiveHttpHeaders, String string, HttpSendBodyMode httpSendBodyMode, HttpStreamingType httpStreamingType, TransformationService transformationService) throws IOException {
        Object object;
        Object object2;
        Object object3 = null;
        bv.debug("buildEntity - content is {}", typedValue);
        TypedValue typedValue2 = typedValue;
        if (typedValue.getValue() instanceof CursorStream) {
            bv.debug("buildEntity - content is CursorStream");
            object2 = (CursorStream)typedValue.getValue();
            long l = object2.getPosition();
            object = (CursorStreamProvider)object2.getProvider();
            typedValue2 = l == 0L ? new TypedValue(object, typedValue.getDataType(), typedValue.getByteLength()) : new TypedValue((Object)new OffsetCursorProviderWrapper((CursorStreamProvider)object, l), typedValue.getDataType(), typedValue.getByteLength());
            bv.debug("buildEntity - resolved content is {}", (Object)typedValue2);
        }
        object2 = typedValue2.getValue();
        OptionalLong optionalLong = typedValue2.getByteLength();
        Optional<String> optional = exclusiveHttpHeaders.W().stream().filter(httpHeader -> httpHeader.getValue() != null && httpHeader.getKey().equalsIgnoreCase("Transfer-Encoding".toLowerCase())).map(httpHeader -> httpHeader.getValue()).findFirst();
        object = exclusiveHttpHeaders.W().stream().filter(httpHeader -> httpHeader.getValue() != null && httpHeader.getKey().equalsIgnoreCase("Content-Length".toLowerCase())).map(httpHeader -> httpHeader.getValue()).findFirst();
        Optional<String> optional2 = exclusiveHttpHeaders.W().stream().filter(httpHeader -> httpHeader.getValue() != null && httpHeader.getKey().equalsIgnoreCase("Content-Type".toLowerCase())).map(httpHeader -> httpHeader.getValue()).findFirst();
        boolean bl = this.a(object2, string, httpSendBodyMode);
        bv.debug("buildEntity - content is empty? {}", (Object)bl);
        MediaType mediaType = typedValue2.getDataType().getMediaType();
        if (!(optional2.isPresent() || bl || MediaType.ANY.matches(mediaType))) {
            httpRequestBuilder.addHeader("Content-Type".toLowerCase(), mediaType.toRfcString());
        }
        if (bl) {
            object3 = new EmptyHttpEntity();
        } else if (object2 instanceof CursorStreamProvider) {
            bv.debug("buildEntity - payload is CursorStreamProvider");
            if (httpStreamingType == HttpStreamingType.ALWAYS) {
                object3 = this.a(httpRequestBuilder, optional, (Optional<String>)object, (CursorStreamProvider)object2);
            } else if (httpStreamingType == HttpStreamingType.AUTO) {
                if (((Optional)object).isPresent()) {
                    this.a(httpRequestBuilder, optional, bz);
                    object3 = new ByteArrayHttpEntity(this.a(((CursorStreamProvider)object2).openCursor(), transformationService));
                } else if (optional.isPresent() && "chunked".equalsIgnoreCase(optional.get()) || !optionalLong.isPresent()) {
                    object3 = new a((CursorStreamProvider)object2);
                } else {
                    this.a(httpRequestBuilder, optional, bB);
                    object3 = this.a(httpRequestBuilder, (CursorStreamProvider)object2, optionalLong);
                }
            } else {
                this.a(httpRequestBuilder, optional, bA);
                object3 = optionalLong.isPresent() ? this.a(httpRequestBuilder, (CursorStreamProvider)object2, optionalLong) : new ByteArrayHttpEntity(this.a(((CursorStreamProvider)object2).openCursor(), transformationService));
            }
        } else if (object2 instanceof InputStream) {
            bv.debug("buildEntity - payload is InputStream");
            if (httpStreamingType == HttpStreamingType.ALWAYS) {
                object3 = this.a(httpRequestBuilder, optional, (Optional<String>)object, (InputStream)object2);
            } else if (httpStreamingType == HttpStreamingType.AUTO) {
                if (((Optional)object).isPresent()) {
                    this.a(httpRequestBuilder, optional, bz);
                    object3 = new ByteArrayHttpEntity(this.a(object2, transformationService));
                } else if (optional.isPresent() && "chunked".equalsIgnoreCase(optional.get()) || !optionalLong.isPresent()) {
                    object3 = new InputStreamHttpEntity((InputStream)object2);
                } else {
                    this.a(httpRequestBuilder, optional, bB);
                    object3 = this.a(httpRequestBuilder, (InputStream)object2, optionalLong);
                }
            } else {
                this.a(httpRequestBuilder, optional, bA);
                object3 = optionalLong.isPresent() ? this.a(httpRequestBuilder, (InputStream)object2, optionalLong) : new ByteArrayHttpEntity(this.a(object2, transformationService));
            }
        } else {
            bv.debug("buildEntity - payload is Object");
            byte[] byArray = this.a(object2, transformationService);
            if (httpStreamingType == HttpStreamingType.ALWAYS) {
                object3 = this.a(httpRequestBuilder, optional, (Optional<String>)object, new ByteArrayInputStream(byArray));
            } else if (httpStreamingType == HttpStreamingType.NEVER) {
                this.a(httpRequestBuilder, optional, bA);
                object3 = new ByteArrayHttpEntity(byArray);
            } else {
                if (((Optional)object).isPresent() && optional.isPresent()) {
                    this.a(httpRequestBuilder, optional, bz);
                }
                object3 = new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(byArray), (long)byArray.length);
            }
        }
        return object3;
    }

    private boolean a(Object object, String string, HttpSendBodyMode httpSendBodyMode) {
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = object != null && !object.equals("");
        if (!bl2) {
            bl = true;
        } else {
            bl = by.contains(string);
            if (httpSendBodyMode != HttpSendBodyMode.AUTO) {
                bl = httpSendBodyMode == HttpSendBodyMode.NEVER;
            }
        }
        return bl;
    }

    private byte[] a(Object object, TransformationService transformationService) {
        return (byte[])transformationService.transform(Message.of((Object)object), DataType.BYTE_ARRAY).getPayload().getValue();
    }

    private HttpEntity a(HttpRequestBuilder httpRequestBuilder, Optional<String> optional, Optional<String> optional2, CursorStreamProvider cursorStreamProvider) {
        this.a(httpRequestBuilder, optional, optional2);
        return new a(cursorStreamProvider);
    }

    private void a(HttpRequestBuilder httpRequestBuilder, Optional<String> optional, Optional<String> optional2) {
        if (optional2 != null) {
            httpRequestBuilder.removeHeader("Content-Length");
            if (bv.isDebugEnabled()) {
                bv.debug("Content-Length header will not be sent, as the configured requestStreamingMode is ALWAYS.");
            }
        }
        if (optional.isPresent() && !optional.get().equalsIgnoreCase("chunked")) {
            httpRequestBuilder.removeHeader("Transfer-Encoding");
            if (bv.isDebugEnabled()) {
                bv.debug("Transfer-Encoding header will be sent with value 'chunked' instead of {}, as the configured requestStreamingMode is ALWAYS", optional);
            }
        }
    }

    private HttpEntity a(HttpRequestBuilder httpRequestBuilder, Optional<String> optional, Optional<String> optional2, InputStream inputStream) {
        this.a(httpRequestBuilder, optional, optional2);
        return new InputStreamHttpEntity(inputStream);
    }

    private void a(HttpRequestBuilder httpRequestBuilder, Optional<String> optional, String string) {
        if (optional.isPresent()) {
            httpRequestBuilder.removeHeader("Transfer-Encoding");
            if (bv.isDebugEnabled()) {
                bv.debug(string);
            }
        }
    }

    private HttpEntity a(HttpRequestBuilder httpRequestBuilder, InputStream inputStream, OptionalLong optionalLong) {
        httpRequestBuilder.addHeader("Content-Length", String.valueOf(optionalLong.getAsLong()));
        return new InputStreamHttpEntity(inputStream, optionalLong.getAsLong());
    }

    private HttpEntity a(HttpRequestBuilder httpRequestBuilder, CursorStreamProvider cursorStreamProvider, OptionalLong optionalLong) {
        httpRequestBuilder.addHeader("Content-Length", String.valueOf(optionalLong.getAsLong()));
        return new a(cursorStreamProvider, optionalLong.getAsLong());
    }

    private void a(Throwable throwable, UriParameters uriParameters) {
        if ("HTTPS".equals(uriParameters.f()) && StringUtils.containsIgnoreCase((CharSequence)throwable.getMessage(), (CharSequence)bE)) {
            bv.error("Remote host closed connection. Possible SSL/TLS handshake issue. Check protocols, cipher suites and certificate set up. Use -Djavax.net.debug=ssl for further debugging.");
        }
    }

    private Supplier<InputStream> a(StreamingHelper streamingHelper, HttpEntity httpEntity) {
        if (streamingHelper == null) {
            return () -> ((HttpEntity)httpEntity).getContent();
        }
        Object object = streamingHelper.resolveCursorProvider((Object)httpEntity.getContent());
        bv.debug("ResultInputStreamSupplier - streaming helper {}, resolved cursor provider: {}, entity: {}", new Object[]{streamingHelper, object, httpEntity});
        if (object instanceof CursorProvider) {
            bv.debug("ResultInputStreamSupplier - opening cursor");
            return () -> ((CursorProvider)((CursorProvider)object)).openCursor();
        }
        return () -> (InputStream)object;
    }

    private HttpAuthentication a(HttpRequestAuthentication httpRequestAuthentication) {
        HttpRequestAuthentication httpRequestAuthentication2 = null;
        if (httpRequestAuthentication instanceof HttpAuthentication) {
            httpRequestAuthentication2 = httpRequestAuthentication;
        }
        return httpRequestAuthentication2;
    }

    URI a(HttpRequestParameter httpRequestParameter, HttpRequestAttributes httpRequestAttributes) throws URISyntaxException {
        URI uRI = new URI(httpRequestParameter.getAddress());
        if (uRI.getPort() == -1) {
            uRI = this.a(uRI) ? new URI(uRI.getScheme(), uRI.getUserInfo(), uRI.getHost(), 443, uRI.getPath(), uRI.getQuery(), uRI.getFragment()) : new URI(uRI.getScheme(), uRI.getUserInfo(), uRI.getHost(), 80, uRI.getPath(), uRI.getQuery(), uRI.getFragment());
        }
        return uRI;
    }

    private boolean a(URI uRI) {
        return "https".equalsIgnoreCase(uRI.getScheme());
    }

    private KeyStoreMappingHolder b(String string, HttpProxyConfig httpProxyConfig) {
        return httpProxyConfig.A().stream().filter(keyStoreMappingHolder -> keyStoreMappingHolder.l(string)).findFirst().orElse(null);
    }

    HttpClientConfiguration a(HttpProxyConfig httpProxyConfig, HttpRequestParameter httpRequestParameter, String string) throws CreateException, KeyStoreException {
        String string2 = String.format(bx, httpProxyConfig.getConfigName());
        ViaHttpProxyConfig viaHttpProxyConfig = httpProxyConfig.Q();
        if (viaHttpProxyConfig != null && bv.isDebugEnabled()) {
            bv.debug("Proxy settings: {}:{}", (Object)viaHttpProxyConfig.getHost(), (Object)viaHttpProxyConfig.getPort());
        }
        cz.integsoft.mule.ipm.api.tcp.TcpClientSocketProperties tcpClientSocketProperties = httpProxyConfig.I();
        HttpClientConfiguration httpClientConfiguration = new HttpClientConfiguration.Builder().setTlsContextFactory(this.b(httpProxyConfig, string)).setProxyConfig((ProxyConfig)viaHttpProxyConfig).setClientSocketProperties(this.a(tcpClientSocketProperties)).setMaxConnections(httpProxyConfig.D().intValue()).setUsePersistentConnections(httpProxyConfig.C()).setConnectionIdleTimeout(httpProxyConfig.C() ? httpProxyConfig.G() : 0).setStreaming(httpProxyConfig.N()).setResponseBufferSize(httpProxyConfig.O()).setName(string2).build();
        return httpClientConfiguration;
    }

    private TlsContextFactory b(HttpProxyConfig httpProxyConfig, String string2) throws CreateException, KeyStoreException {
        TlsContextFactoryBuilder tlsContextFactoryBuilder = TlsContextFactory.builder();
        if (httpProxyConfig.M()) {
            bv.debug("Setting trust to all certificates");
            tlsContextFactoryBuilder.insecureTrustStore(true);
        } else if (httpProxyConfig.z() != null) {
            bv.debug("Adding trust store to SSL context.");
            tlsContextFactoryBuilder.insecureTrustStore(false).trustStoreType(httpProxyConfig.z().ah().getType()).enabledProtocols(httpProxyConfig.L()).trustStorePath(httpProxyConfig.z().aj().toString());
            if (httpProxyConfig.B().getPassword() != null) {
                tlsContextFactoryBuilder.trustStorePassword(httpProxyConfig.B().getPassword());
            }
        }
        KeyStoreMappingHolder keyStoreMappingHolder = this.b(string2, httpProxyConfig);
        bv.debug("Found client keystore {} for request path: {}", (Object)keyStoreMappingHolder, (Object)string2);
        if (keyStoreMappingHolder != null) {
            Enumeration<String> enumeration;
            bv.debug("Adding client certificate to SSL context.");
            if (bv.isDebugEnabled()) {
                enumeration = keyStoreMappingHolder.ah().aliases();
                bv.debug("Available keystore aliases: {}", (Object)StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<String>(){

                    public String V() {
                        return (String)enumeration.nextElement();
                    }

                    @Override
                    public boolean hasNext() {
                        return enumeration.hasMoreElements();
                    }

                    @Override
                    public /* synthetic */ Object next() {
                        return this.V();
                    }
                }, 16), false).collect(Collectors.joining(",")));
            }
            enumeration = keyStoreMappingHolder.ah().aliases();
            StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<String>(){

                public String V() {
                    return (String)enumeration.nextElement();
                }

                @Override
                public boolean hasNext() {
                    return enumeration.hasMoreElements();
                }

                @Override
                public /* synthetic */ Object next() {
                    return this.V();
                }
            }, 16), false).filter(string -> string.equals(keyStoreMappingHolder.c())).findFirst().orElseThrow(() -> new IllegalArgumentException(""));
            tlsContextFactoryBuilder.keyStoreType(keyStoreMappingHolder.ah().getType()).keyStorePath(keyStoreMappingHolder.aj().toString()).enabledProtocols(httpProxyConfig.L()).keyAlias(keyStoreMappingHolder.c());
            if (keyStoreMappingHolder.getPassword() != null) {
                tlsContextFactoryBuilder.keyStorePassword(keyStoreMappingHolder.getPassword());
            } else {
                bv.warn("Setting empty store password. You should check if this is really intended!");
                tlsContextFactoryBuilder.keyStorePassword("");
            }
            if (keyStoreMappingHolder.d() != null) {
                tlsContextFactoryBuilder.keyPassword(keyStoreMappingHolder.d());
            } else {
                bv.warn("Setting empty key password. You should check if this is really intended!");
                tlsContextFactoryBuilder.keyPassword("");
            }
        }
        return tlsContextFactoryBuilder.build();
    }

    private TcpClientSocketProperties a(cz.integsoft.mule.ipm.api.tcp.TcpClientSocketProperties tcpClientSocketProperties) {
        return TcpClientSocketProperties.builder().sendBufferSize(tcpClientSocketProperties.h()).receiveBufferSize(tcpClientSocketProperties.i()).clientTimeout(tcpClientSocketProperties.j()).connectionTimeout(tcpClientSocketProperties.p()).keepAlive(Boolean.valueOf(tcpClientSocketProperties.n())).linger(tcpClientSocketProperties.m()).sendTcpNoDelay(Boolean.valueOf(tcpClientSocketProperties.l())).build();
    }

    private class a
    implements HttpEntity {
        private Long bK;
        private final CursorStreamProvider bL;

        a(CursorStreamProvider cursorStreamProvider) {
            Objects.requireNonNull(cursorStreamProvider, "HTTP entity stream provider cannot be null.");
            this.bL = cursorStreamProvider;
        }

        a(CursorStreamProvider cursorStreamProvider, Long l) {
            this(cursorStreamProvider);
            this.bK = l;
        }

        public boolean isStreaming() {
            return true;
        }

        public boolean isComposed() {
            return false;
        }

        public InputStream getContent() {
            return (InputStream)this.bL.openCursor();
        }

        public byte[] getBytes() {
            return IOUtils.toByteArray((InputStream)this.getContent());
        }

        public Collection<HttpPart> getParts() {
            return Collections.emptyList();
        }

        public Optional<Long> getLength() {
            return Optional.ofNullable(this.bK);
        }
    }
}

