/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.ipm.api.failover;

import cz.integsoft.mule.ipm.api.ProxyErrorCode;
import cz.integsoft.mule.ipm.api.exception.NoHostAvailableException;
import cz.integsoft.mule.ipm.api.failover.FailoverEvent;
import cz.integsoft.mule.ipm.api.failover.FailoverGroup;
import cz.integsoft.mule.ipm.api.failover.FailoverHost;
import cz.integsoft.mule.ipm.api.failover.FailoverManager;
import cz.integsoft.mule.ipm.api.failover.FailoverNotificationObserver;
import cz.integsoft.mule.ipm.api.failover.FailoverTestingStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.TypeDsl;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="simple-failover-manager")
@TypeDsl(allowTopLevelDefinition=true, allowInlineDefinition=true)
public class DefaultFailoverManager
implements FailoverManager<FailoverHost> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFailoverManager.class);
    private static final int THREAD_POOL_SHUTDOWN_TIMEOUT = 5;
    private boolean started;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(order=1, tab="Connection")
    @Summary(value="Failover group (set of hosts for checking availability).")
    @Alias(value="failover-group")
    private FailoverGroup<FailoverHost> failoverGroup;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(order=2, tab="General")
    @Summary(value="If this failover manager throws CONNECTIVITY error if no route is available. Default is false.")
    @Alias(value="exception-on-no-hosts")
    private boolean exceptionOnNoHosts;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="true")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(order=3, tab="General")
    @Summary(value="If this failover manager notifies registered observers, e.g. circuit breaker. Default is true.")
    @Alias(value="enable-notifications")
    private boolean enableNotifications;
    @Parameter
    @Placement(order=4, tab="General")
    @Alias(value="test-strategy")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="Required testing strategy. This strategy is executed to determine, if the given host is accessible or not.")
    private FailoverTestingStrategy<FailoverHost> testingStrategy;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="5000")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(order=5, tab="General")
    @Summary(value="The period for checking hosts with the given strategy (in milliseconds). Default is 5000.")
    @Alias(value="period")
    private long period;
    private final Map<String, FailoverHost> availableHosts = new ConcurrentHashMap<String, FailoverHost>();
    private final List<FailoverNotificationObserver<FailoverHost>> observers = new ArrayList<FailoverNotificationObserver<FailoverHost>>();
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private SchedulerConfig schedulerConfig;
    private Scheduler scheduler;

    @Override
    public FailoverHost getFirst() {
        return this.getNext();
    }

    @Override
    public FailoverHost getNext() {
        Optional optional = this.availableHosts.entrySet().stream().findFirst();
        if (!optional.isPresent()) {
            if (this.enableNotifications) {
                this.notifyNoHostsLeft();
            }
            if (this.exceptionOnNoHosts) {
                throw new NoHostAvailableException(ProxyErrorCode.IPM_FOV_001, "No more available hosts left!");
            }
            return null;
        }
        FailoverHost failoverHost = (FailoverHost)((Map.Entry)optional.get()).getValue();
        return failoverHost;
    }

    @Override
    public void hostDown(FailoverHost failoverHost) {
        if (failoverHost == null) {
            return;
        }
        if (this.checkHost(failoverHost)) {
            LOGGER.debug("Host {} is down, so removing it from the available hosts", (Object)failoverHost);
            this.availableHosts.remove(failoverHost.getId());
        }
    }

    @Override
    public void hostUp(FailoverHost failoverHost) {
        if (failoverHost == null) {
            return;
        }
        if (this.checkHost(failoverHost)) {
            LOGGER.debug("Host {} is up, so adding it to the available hosts", (Object)failoverHost);
            this.availableHosts.putIfAbsent(failoverHost.getId(), failoverHost);
        }
    }

    @Override
    public FailoverTestingStrategy<FailoverHost> getFailoverTestingStrategy() {
        return this.testingStrategy;
    }

    @Override
    public boolean isNotificationEnabled() {
        return this.enableNotifications;
    }

    @Override
    public boolean isExceptionOnNoHosts() {
        return this.exceptionOnNoHosts;
    }

    public final FailoverGroup<FailoverHost> getFailoverGroup() {
        return this.failoverGroup;
    }

    public final boolean isEnableNotifications() {
        return this.enableNotifications;
    }

    public final FailoverTestingStrategy<FailoverHost> getTestingStrategy() {
        return this.testingStrategy;
    }

    public final long getPeriod() {
        return this.period;
    }

    @Override
    public void registerObserver(FailoverNotificationObserver<FailoverHost> failoverNotificationObserver) {
        if (failoverNotificationObserver == null) {
            return;
        }
        LOGGER.debug("Registering observer: {}", failoverNotificationObserver);
        if (!this.observers.contains(failoverNotificationObserver)) {
            this.observers.add(failoverNotificationObserver);
        }
    }

    @Override
    public void unregisterObserver(FailoverNotificationObserver<FailoverHost> failoverNotificationObserver) {
        if (failoverNotificationObserver == null) {
            return;
        }
        LOGGER.debug("Unregistering observer: {}", failoverNotificationObserver);
        this.observers.remove(failoverNotificationObserver);
    }

    @Override
    public void close() throws Exception {
        LOGGER.debug("Closing {}", (Object)this);
        this.observers.clear();
        this.availableHosts.clear();
    }

    @Override
    public void stop() throws MuleException {
        LOGGER.debug("Stopping {}", (Object)this);
        if (this.scheduler != null) {
            LOGGER.debug("Stopping scheduler... {}", (Object)this.scheduler);
            this.scheduler.stop();
        }
        try {
            this.close();
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to close failover manager", (Throwable)exception);
        }
        finally {
            this.started = false;
        }
    }

    @Override
    public void start() throws MuleException {
        if (this.started) {
            LOGGER.warn("Failover Manager is already started. Skipping...");
            return;
        }
        LOGGER.debug("Starting {}", (Object)this);
        this.failoverGroup.getHosts().stream().filter(failoverHost -> this.testingStrategy.isAvailable((FailoverHost)failoverHost)).forEach(failoverHost -> this.availableHosts.put(failoverHost.getId(), (FailoverHost)failoverHost));
        LOGGER.debug("Starting...scheduler service {} with config {}", (Object)this.schedulerService, (Object)this.schedulerConfig);
        this.scheduler = this.schedulerService.customScheduler(this.schedulerConfig.withMaxConcurrentTasks(1).withName("failovermanager-hosts-checking-" + this).withWaitAllowed(true).withShutdownTimeout(5L, TimeUnit.SECONDS));
        LOGGER.debug("Scheduler has been initialized: {}", (Object)this.scheduler);
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                DefaultFailoverManager.this.failoverGroup.getHosts().parallelStream().forEach(failoverHost -> {
                    boolean bl = DefaultFailoverManager.this.testingStrategy.isAvailable(failoverHost);
                    if (bl) {
                        if (!DefaultFailoverManager.this.availableHosts.containsKey(failoverHost.getId())) {
                            DefaultFailoverManager.this.hostUp((FailoverHost)failoverHost);
                            if (DefaultFailoverManager.this.enableNotifications) {
                                DefaultFailoverManager.this.notifyHostUp(failoverHost);
                            }
                        }
                    } else if (DefaultFailoverManager.this.availableHosts.containsKey(failoverHost.getId())) {
                        DefaultFailoverManager.this.hostDown((FailoverHost)failoverHost);
                        if (DefaultFailoverManager.this.enableNotifications) {
                            DefaultFailoverManager.this.notifyHostDown(failoverHost);
                        }
                    }
                });
                if (DefaultFailoverManager.this.availableHosts.isEmpty() && DefaultFailoverManager.this.enableNotifications) {
                    DefaultFailoverManager.this.notifyNoHostsLeft();
                }
            }
        }, 0L, this.period, TimeUnit.MILLISECONDS);
        this.started = true;
    }

    private boolean checkHost(FailoverHost failoverHost) {
        return this.failoverGroup.getHosts().parallelStream().anyMatch(failoverHost2 -> failoverHost2.equals(failoverHost));
    }

    private void notifyHostDown(final FailoverHost failoverHost) {
        final DefaultFailoverManager defaultFailoverManager = this;
        CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                DefaultFailoverManager.this.observers.forEach(failoverNotificationObserver -> failoverNotificationObserver.notify(FailoverEvent.HOST_DOWN, defaultFailoverManager, failoverHost));
            }
        });
    }

    private void notifyHostUp(final FailoverHost failoverHost) {
        final DefaultFailoverManager defaultFailoverManager = this;
        CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                DefaultFailoverManager.this.observers.forEach(failoverNotificationObserver -> failoverNotificationObserver.notify(FailoverEvent.HOST_UP, defaultFailoverManager, failoverHost));
            }
        });
    }

    private void notifyNoHostsLeft() {
        final DefaultFailoverManager defaultFailoverManager = this;
        CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                DefaultFailoverManager.this.observers.forEach(failoverNotificationObserver -> failoverNotificationObserver.notify(FailoverEvent.NO_HOST_AVAILABLE, defaultFailoverManager, null));
            }
        });
    }
}

