/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.ipm.internal.http.operation;

import cz.integsoft.mule.ipm.api.ProxyErrorCode;
import cz.integsoft.mule.ipm.api.exception.ConnectionException;
import cz.integsoft.mule.ipm.api.exception.ProcessingException;
import cz.integsoft.mule.ipm.api.http.ProxyHttpResponseAttributes;
import cz.integsoft.mule.ipm.api.http.authentication.HttpRequestAuthentication;
import cz.integsoft.mule.ipm.api.http.parameter.UriParameters;
import cz.integsoft.mule.ipm.internal.AbstractOperation;
import cz.integsoft.mule.ipm.internal.error.GenericErrorTypeProvider;
import cz.integsoft.mule.ipm.internal.http.HttpClientConnectionManager;
import cz.integsoft.mule.ipm.internal.http.HttpExtensionClient;
import cz.integsoft.mule.ipm.internal.http.ShareableHttpClient;
import cz.integsoft.mule.ipm.internal.http.config.HttpProxyConfig;
import cz.integsoft.mule.ipm.internal.http.operation.HttpProxyOperationDelegate;
import cz.integsoft.mule.ipm.internal.http.parameter.ExclusiveHttpHeaders;
import cz.integsoft.mule.ipm.internal.http.parameter.HttpRequestParameter;
import java.io.InputStream;
import java.net.URI;
import java.security.KeyStoreException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Streaming;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProxyOperation
extends AbstractOperation {
    private static final Logger bo = LoggerFactory.getLogger(HttpProxyOperation.class);
    private static final String bp = "|unknown|";
    @Inject
    private HttpClientConnectionManager aS;
    @Inject
    private TransformationService bq;
    @Inject
    private MuleContext aT;
    private final Map<String, String> br = new ConcurrentHashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Throws(value={GenericErrorTypeProvider.class})
    @Alias(value="http-outbound-endpoint")
    @MediaType(value="*/*", strict=false)
    @Streaming
    public void a(@Config HttpProxyConfig httpProxyConfig, @ParameterGroup(name="HTTP headers") ExclusiveHttpHeaders exclusiveHttpHeaders, @ParameterGroup(name="HTTP request parameters") HttpRequestParameter httpRequestParameter, @DefaultEncoding String string, @Alias(value="attributes", description="Message attributes. Defaults to #[attributes]") @Optional(defaultValue="#[attributes]") Object object, @Alias(value="payload", description="The HTTP payload") @Content(primary=true) TypedValue<Object> typedValue, StreamingHelper streamingHelper, CompletionCallback<InputStream, ProxyHttpResponseAttributes> completionCallback) {
        bo.debug("in HTTP Proxy component: outboundUrl={}", (Object)httpRequestParameter.getAddress());
        this.s();
        HttpExtensionClient httpExtensionClient = null;
        try {
            if (object == null) {
                throw new ProcessingException(ProxyErrorCode.IPM_ANY_003, "Missing request attributes in the incoming message. Do you have http:listener before?");
            }
            if (!(object instanceof HttpRequestAttributes)) {
                throw new ProcessingException(ProxyErrorCode.IPM_ANY_004, "Bad request attributes. It is expected that attributes are instance of HttpRequestAttributes.");
            }
            HttpProxyOperationDelegate httpProxyOperationDelegate = new HttpProxyOperationDelegate();
            HttpRequestAttributes httpRequestAttributes = (HttpRequestAttributes)object;
            String string2 = httpRequestAttributes.getRequestPath();
            URI uRI = httpProxyOperationDelegate.a(httpRequestParameter, httpRequestAttributes);
            Class<HttpClientConnectionManager> clazz = HttpClientConnectionManager.class;
            synchronized (HttpClientConnectionManager.class) {
                ShareableHttpClient shareableHttpClient = this.aS.lookupOrCreate(this.a(string2, httpProxyConfig), () -> {
                    try {
                        bo.debug("Creating new HTTP client configuration for requestPath {}", (Object)string2);
                        return httpProxyOperationDelegate.a(httpProxyConfig, httpRequestParameter, string2);
                    }
                    catch (KeyStoreException | CreateException throwable) {
                        throw new RuntimeException("Failed to create HTTP client configuration! " + throwable.getLocalizedMessage(), throwable);
                    }
                });
                UriParameters uriParameters = new UriParameters(HttpConstants.Protocol.valueOf((String)uRI.getScheme().toUpperCase()), uRI.getHost(), uRI.getPort());
                HttpRequestAuthentication httpRequestAuthentication = httpProxyConfig.R();
                httpExtensionClient = new HttpExtensionClient(shareableHttpClient, uriParameters, httpRequestAuthentication);
                try {
                    httpExtensionClient.start();
                }
                catch (MuleException muleException) {
                    throw new ConnectionException(muleException);
                }
                try {
                    httpProxyOperationDelegate.a(typedValue, exclusiveHttpHeaders, httpRequestParameter, httpRequestAttributes, httpExtensionClient, uRI, httpProxyConfig, completionCallback, streamingHelper, httpRequestParameter.ae(), httpRequestParameter.af(), this.bq, httpRequestParameter.aa());
                }
                catch (Exception exception) {
                    try {
                        if (httpExtensionClient != null) {
                            httpExtensionClient.stop();
                        }
                    }
                    catch (MuleException muleException) {
                        bo.warn("Found exception trying to stop http client: " + muleException.getMessage(), (Throwable)muleException);
                    }
                    throw exception;
                }
            }
        }
        catch (Throwable throwable) {
            completionCallback.error((Throwable)((Object)new ProcessingException(ProxyErrorCode.IPM_SND_003, "Error occurred while sending http request to " + httpRequestParameter.getAddress() + ": " + throwable.getLocalizedMessage(), throwable)));
        }
        {
            return;
        }
    }

    private String a(String string2, HttpProxyConfig httpProxyConfig) {
        String string3 = this.br.computeIfAbsent(string2, string -> httpProxyConfig.A().stream().filter(keyStoreMappingHolder -> keyStoreMappingHolder.l((String)string)).map(keyStoreMappingHolder -> keyStoreMappingHolder.e()).findFirst().orElse(bp));
        if (httpProxyConfig.Q() != null) {
            string3 = string3 + "_viaproxy" + httpProxyConfig.Q().hashCode();
        }
        return this.aT.getId() + "_" + httpProxyConfig.getConfigName() + "_" + string3;
    }
}

