/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.ipm.internal.http.parameter;

import cz.integsoft.mule.ipm.api.http.HttpSendBodyMode;
import cz.integsoft.mule.ipm.api.http.HttpStreamingType;
import cz.integsoft.mule.ipm.internal.http.parameter.HttpMethodValueProvider;
import java.util.Objects;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.values.OfValues;

public class HttpRequestParameter {
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Alias(value="address", description="Outbound address. Can be expression.")
    private String bP;
    @Parameter
    @Optional
    @OfValues(value=HttpMethodValueProvider.class)
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Alias(value="method", description="Defines HTTP method to use. Basically it overrides the incoming HTTP method. It's optional with no default.")
    private String bQ;
    @Parameter
    @Optional
    @Content
    @NullSafe
    @Alias(value="query-parameters")
    private MultiMap<String, String> bR = MultiMap.emptyMultiMap();
    @Parameter
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Alias(value="log-http-traffic", description="Boolean parameter to specify if to log HTTP traffic. It's optional with default value false.")
    @Summary(value="Deprecated. Has no effect.")
    @Deprecated
    private boolean bS;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Alias(value="request-hard-timeout")
    @Summary(value="Deprecated. Has no effect.")
    @Deprecated
    private Long bT;
    @Parameter
    @Optional
    @Alias(value="response-timeout")
    private Integer bU;
    @Parameter
    @Optional(defaultValue="AUTO")
    @Alias(value="send-body-mode")
    private HttpSendBodyMode bV;
    @Parameter
    @Optional(defaultValue="AUTO")
    @Summary(value="Defines if the request should be sent using streaming or not. If this attribute is not present, the behavior will depend on the type of the payload (it will stream only for InputStream).")
    @Alias(value="request-streaming-mode")
    private HttpStreamingType bW;
    @Parameter
    @Optional(defaultValue="3")
    @Alias(value="ssl-failure-retry-attempts")
    private Integer bX;

    public void k(String string) {
        this.bP = string;
    }

    public String getAddress() {
        return this.bP;
    }

    public MultiMap<String, String> Y() {
        return this.bR;
    }

    public String Z() {
        return this.bQ;
    }

    public void b(MultiMap<String, String> multiMap) {
        this.bR = multiMap != null ? multiMap : MultiMap.emptyMultiMap();
    }

    public Integer aa() {
        return this.bX;
    }

    public final boolean ab() {
        return this.bS;
    }

    public final Long ac() {
        return this.bT;
    }

    public final Integer ad() {
        return this.bU;
    }

    public final HttpSendBodyMode ae() {
        return this.bV;
    }

    public final HttpStreamingType af() {
        return this.bW;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("HttpRequestParameter [address=").append(this.bP).append(", method=").append(this.bQ).append(", queryParameters=").append(this.bR).append(", logTraffic=").append(this.bS).append(", requestHardTimeout=").append(this.bT).append(", sslFailureRetryAttempts=").append(this.bX).append("]");
        return stringBuilder.toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bP, this.bS, this.bQ, this.bR, this.bT, this.bU, this.bV, this.bW, this.bX});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HttpRequestParameter httpRequestParameter = (HttpRequestParameter)object;
        return Objects.equals(this.bP, httpRequestParameter.bP) && this.bS == httpRequestParameter.bS && Objects.equals(this.bQ, httpRequestParameter.bQ) && Objects.equals(this.bR, httpRequestParameter.bR) && Objects.equals(this.bT, httpRequestParameter.bT) && Objects.equals(this.bU, httpRequestParameter.bU) && Objects.equals((Object)this.bV, (Object)httpRequestParameter.bV) && Objects.equals((Object)this.bW, (Object)httpRequestParameter.bW) && Objects.equals(this.bX, httpRequestParameter.bX);
    }
}

