/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.ipm.internal.socket.tcp.config;

import cz.integsoft.mule.ipm.api.tcp.TcpServerSocketProperties;
import cz.integsoft.mule.ipm.internal.socket.tcp.source.TcpSocketListener;
import java.net.InetSocketAddress;
import org.mule.extension.socket.api.SocketConnectionSettings;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Sources;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

@Configuration(name="tcp-proxy-listener-config")
@Sources(value={TcpSocketListener.class})
public class TcpListenerConfig {
    private static final int PORT_CHOSEN_BY_SYSTEM_MASK = 0;
    @Parameter
    @Optional
    @NullSafe
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Alias(value="tcp-server-socket-properties")
    private TcpServerSocketProperties tcpServerSocketProperties;
    @Parameter
    @Optional
    @Placement(tab="TLS")
    @DisplayName(value="TLS Configuration")
    private TlsContextFactory tlsContext;
    @Parameter
    @Optional
    @Placement(tab="Local Address Settings")
    @Alias(value="local-address")
    private final SocketConnectionSettings localAddressSettings = new SocketConnectionSettings();
    @Parameter
    @Placement(order=2)
    private Integer port;
    @Parameter
    @Placement(order=1)
    private String host;

    public TcpServerSocketProperties getTcpServerSocketProperties() {
        return this.tcpServerSocketProperties;
    }

    public TlsContextFactory getTlsContext() {
        return this.tlsContext;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public SocketConnectionSettings getLocalAddressSettings() {
        return this.localAddressSettings;
    }

    public InetSocketAddress getInetSocketAddress() {
        if (this.isEmpty()) {
            return new InetSocketAddress(0);
        }
        if (this.port == null && !StringUtils.isBlank((String)this.host)) {
            return new InetSocketAddress(this.host, 0);
        }
        if (this.port != null && StringUtils.isBlank((String)this.host)) {
            return new InetSocketAddress(this.port);
        }
        return new InetSocketAddress(this.host, (int)this.port);
    }

    public String toString() {
        return String.format("Host %s Port %s", this.host, this.port != null ? this.port.toString() : "");
    }

    private boolean isEmpty() {
        return StringUtils.isBlank((String)this.host) && this.port == null;
    }
}

