/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.itm.internal.component;

import cz.integsoft.mule.itm.api.ToolBoxModuleErrorCode;
import cz.integsoft.mule.itm.api.exception.CounterException;
import cz.integsoft.mule.itm.api.util.ToolBoxModuleUtils;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.text.MessageFormat;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.lock.LockFactory;

public class OffsetFileStore {
    @Inject
    private LockFactory lockFactory;

    public void write(Path file, String data) {
        this.withKeyLock(file.toString(), key -> {
            try {
                Files.write(file, data.getBytes("utf-8"), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
                return null;
            }
            catch (Exception e) {
                throw new CounterException(ToolBoxModuleErrorCode.ITM_CNT_002, MessageFormat.format("Failed to write offset to file {0}! {1}", file.toString(), e.getLocalizedMessage()), (Throwable)e);
            }
        });
    }

    public String read(Path file) {
        return this.withKeyLock(file.toString(), key -> {
            try {
                byte[] data = Files.readAllBytes(file);
                return new String(data);
            }
            catch (Exception e) {
                throw new CounterException(ToolBoxModuleErrorCode.ITM_CNT_003, MessageFormat.format("Failed to read offset from file {0}! {1}", file.toString(), e.getLocalizedMessage()), (Throwable)e);
            }
        });
    }

    public long incAndGet(Path file) {
        return this.withKeyLock(file.toString(), key -> {
            try {
                byte[] data = Files.readAllBytes(file);
                long offset = ToolBoxModuleUtils.parseOffset(new String(data));
                Files.write(file, Long.toString(++offset).getBytes("utf-8"), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
                return offset;
            }
            catch (Exception e) {
                throw new CounterException(ToolBoxModuleErrorCode.ITM_CNT_004, MessageFormat.format("Failed increment offset in file {0}! {1}", file.toString(), e.getLocalizedMessage()), (Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withKeyLock(String key, Function<String, T> producer) {
        Lock lock = this.lockFactory.createLock(key);
        lock.lock();
        try {
            T t = producer.apply(key);
            return t;
        }
        finally {
            lock.unlock();
        }
    }
}

