/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.itm.internal.config;

import cz.integsoft.mule.itm.internal.operation.CacheManagerDelegate;
import cz.integsoft.mule.itm.internal.operation.CacheOperation;
import javax.inject.Inject;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.ExternalLibraryType;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.ExternalLib;
import org.mule.runtime.extension.api.annotation.ExternalLibs;
import org.mule.runtime.extension.api.annotation.Ignore;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operations(value={CacheOperation.class})
@Configuration(name="cache-config")
@ExternalLibs(value={@ExternalLib(name="Spring Core", coordinates="org.springframework:spring-core:[4.0.0.RELEASE,)", type=ExternalLibraryType.DEPENDENCY), @ExternalLib(name="Spring Context", coordinates="org.springframework:spring-context:[4.0.0.RELEASE,)", type=ExternalLibraryType.DEPENDENCY), @ExternalLib(name="Spring Context Support", coordinates="org.springframework:spring-context-support:[4.0.0.RELEASE,)", type=ExternalLibraryType.DEPENDENCY)})
public class CacheConfig
implements Initialisable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheConfig.class);
    @Ignore
    private CacheManagerDelegate cacheManagerDelegate;
    @Inject
    private Registry registry;
    @RefName
    private String configName;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Alias(value="cache-manager-name")
    private String cacheManagerName;

    public String getConfigName() {
        return this.configName;
    }

    public String getCacheManagerName() {
        return this.cacheManagerName;
    }

    public CacheManagerDelegate getCacheManagerDelegate() {
        return this.cacheManagerDelegate;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CacheConfig [cacheManager=").append(this.cacheManagerDelegate.getCacheManager()).append(", cacheManagerName=").append(this.cacheManagerName).append("]");
        return builder.toString();
    }

    public void initialise() throws InitialisationException {
        LOGGER.info("Initializing config with name {}", (Object)this.configName);
        this.cacheManagerDelegate = new CacheManagerDelegate(this.registry, this.cacheManagerName);
        LOGGER.info("Initializing config with name {} done", (Object)this.configName);
    }
}

