/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.itm.internal.function;

import cz.integsoft.mule.itm.api.ToolBoxModuleErrorCode;
import cz.integsoft.mule.itm.api.exception.CacheException;
import cz.integsoft.mule.itm.internal.error.GenericErrorTypeProvider;
import cz.integsoft.mule.itm.internal.metadata.JavaMetadataResolver;
import cz.integsoft.mule.itm.internal.operation.CacheDelegate;
import java.text.MessageFormat;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModuleFunctions {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleFunctions.class);
    @Inject
    private Registry registry;

    @Alias(value="cacheClear")
    @Throws(value={GenericErrorTypeProvider.class})
    public void clear(String cacheManagerName, String cacheName) {
        CacheDelegate delegate = new CacheDelegate(this.registry, cacheManagerName);
        LOGGER.debug("Clearing cache {}", (Object)cacheName);
        delegate.clear(cacheName);
    }

    @Alias(value="cacheEvict")
    @Throws(value={GenericErrorTypeProvider.class})
    public void evict(String cacheManagerName, String cacheName, Object key) {
        CacheDelegate delegate = new CacheDelegate(this.registry, cacheManagerName);
        LOGGER.debug("Removing from cache {} key {}", (Object)cacheName, key);
        delegate.evict(cacheName, key);
    }

    @MediaType(value="*/*", strict=false)
    @Alias(value="cacheGet")
    @Throws(value={GenericErrorTypeProvider.class})
    @OutputResolver(output=JavaMetadataResolver.class)
    public Object get(String cacheManagerName, String cacheName, Object key, @Optional String clazzName) {
        CacheDelegate delegate = new CacheDelegate(this.registry, cacheManagerName);
        LOGGER.debug("Getting value from cache {} under key {}", (Object)cacheName, key);
        Object value = null;
        if (StringUtils.isBlank((CharSequence)clazzName)) {
            value = delegate.get(cacheName, key);
        } else {
            Class<?> clazz = null;
            try {
                LOGGER.debug("Loading class from {}", (Object)clazzName);
                clazz = Class.forName(clazzName);
            }
            catch (ClassNotFoundException e) {
                throw new CacheException(ToolBoxModuleErrorCode.ITM_CACHE_006, MessageFormat.format("Problem loading class type {0} while trying to get data from the cache ''{1}'': {2}", clazzName, cacheName, e.getLocalizedMessage()), (Throwable)e);
            }
            value = delegate.get(cacheName, key, clazz);
        }
        return value;
    }

    @Alias(value="cachePut")
    @Throws(value={GenericErrorTypeProvider.class})
    public void put(String cacheManagerName, String cacheName, Object key, Object value) {
        CacheDelegate delegate = new CacheDelegate(this.registry, cacheManagerName);
        LOGGER.debug("Adding to the cache {} key: {} value: {}", new Object[]{cacheName, key, value});
        delegate.put(cacheName, key, value);
    }

    @Alias(value="cachePutIfAbsent")
    @Throws(value={GenericErrorTypeProvider.class})
    @OutputResolver(output=JavaMetadataResolver.class)
    public Object putIfAbsent(String cacheManagerName, String cacheName, Object key, Object value) {
        CacheDelegate delegate = new CacheDelegate(this.registry, cacheManagerName);
        LOGGER.debug("Adding to the cache {} key: {} value: {}", new Object[]{cacheName, key, value});
        Object oldValue = delegate.putIfAbsent(cacheName, key, value);
        return oldValue;
    }

    @MediaType(value="*/*", strict=false)
    @Alias(value="cacheGetAllKeys")
    @Throws(value={GenericErrorTypeProvider.class})
    @OutputResolver(output=JavaMetadataResolver.class)
    public Object getAllKeys(String cacheManagerName, String cacheName) {
        CacheDelegate delegate = new CacheDelegate(this.registry, cacheManagerName);
        LOGGER.debug("Getting all keys from cache {}", (Object)cacheName);
        return delegate.getAllKeys(cacheName);
    }
}

