/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.itm.internal.operation;

import cz.integsoft.mule.itm.api.ToolBoxModuleErrorCode;
import cz.integsoft.mule.itm.api.exception.ProcessingException;
import cz.integsoft.mule.itm.api.http.Compression;
import cz.integsoft.mule.itm.api.http.HttpResponseAttributes;
import cz.integsoft.mule.itm.internal.error.GenericErrorTypeProvider;
import cz.integsoft.mule.itm.internal.parameter.WsdlParameters;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Streaming;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SoapSupportOperation
implements Initialisable {
    private static final int BUFFER_SIZE = 1024;
    private static final Logger LOGGER = LoggerFactory.getLogger(SoapSupportOperation.class);
    private DocumentBuilderFactory xmlDocFactory;
    private XPath xpath;
    private TransformerFactory transformerFactory;
    private static final String LOCATION_ATTR_NAME = "location";
    private static final String ADDRESS_ELEMENT_NAME = "address";

    @Execution(value=ExecutionType.CPU_INTENSIVE)
    @Alias(value="replace-wsdl-location")
    @MediaType(value="*/*", strict=false)
    @Throws(value={GenericErrorTypeProvider.class})
    @Streaming
    public Result<InputStream, HttpResponseAttributes> replaceWsdlLocation(@ParameterGroup(name="Wsdl Parameters") WsdlParameters parameters, @Alias(value="attributes", description="Message attributes. Defaults to #[attributes]") @Optional(defaultValue="#[attributes]") Object attributes, @Content InputStream content, StreamingHelper streamingHelper) {
        try {
            if (attributes == null) {
                throw new ProcessingException(ToolBoxModuleErrorCode.ITM_WSDL_002, "Missing attributes in the incoming message. Do you have http:request before?");
            }
            if (!(attributes instanceof org.mule.extension.http.api.HttpResponseAttributes)) {
                throw new ProcessingException(ToolBoxModuleErrorCode.ITM_WSDL_003, "Bad response attributes. It is expected that attributes are instance of HttpResponseAttributes.");
            }
            org.mule.extension.http.api.HttpResponseAttributes respAttrs = (org.mule.extension.http.api.HttpResponseAttributes)attributes;
            Pattern pattern = Pattern.compile(parameters.getUriPattern());
            Matcher matcher = pattern.matcher(parameters.getRequestedUri());
            Result.Builder responseBuilder = Result.builder();
            if (matcher.matches()) {
                LOGGER.debug("Matching URI pattern {} for {}", (Object)parameters.getUriPattern(), (Object)parameters.getRequestedUri());
                InputStream newXmlData = this.replaceXmlAttribute(ADDRESS_ELEMENT_NAME, LOCATION_ATTR_NAME, parameters.getLocation(), content, respAttrs);
                return Result.builder().output((Object)newXmlData).attributes((Object)new HttpResponseAttributes(respAttrs.getStatusCode(), respAttrs.getReasonPhrase(), (MultiMap<String, String>)respAttrs.getHeaders())).build();
            }
            return responseBuilder.output((Object)content).attributes((Object)new HttpResponseAttributes(respAttrs.getStatusCode(), respAttrs.getReasonPhrase(), (MultiMap<String, String>)respAttrs.getHeaders())).build();
        }
        catch (Exception e) {
            throw new ProcessingException(ToolBoxModuleErrorCode.ITM_WSDL_001, (Throwable)e);
        }
    }

    public void initialise() throws InitialisationException {
        try {
            this.xmlDocFactory = DocumentBuilderFactory.newInstance();
            this.xmlDocFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            this.xmlDocFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            this.xpath = XPathFactory.newInstance().newXPath();
            this.transformerFactory = TransformerFactory.newInstance();
            this.transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    private InputStream replaceXmlAttribute(String elementName, String attributeName, String attributeValue, InputStream xmlData, org.mule.extension.http.api.HttpResponseAttributes respAttrs) throws ProcessingException, IOException {
        Compression compression = this.getCompression(respAttrs);
        LOGGER.debug("Determined compression: {}", (Object)compression);
        Document xmlDoc = null;
        try {
            xmlDoc = this.xmlDocFactory.newDocumentBuilder().parse(this.handleDecompression(xmlData, compression));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOGGER.warn("Failed to parse XML document. Most likely it is not XML document at all. Ignoring this exception and returning the original data.", (Throwable)e);
            return xmlData;
        }
        String expr = String.format("//*//*[local-name() = '%s' and @%s]", elementName, attributeName);
        try {
            NodeList nodes = (NodeList)this.xpath.evaluate(expr, xmlDoc, XPathConstants.NODESET);
            if (nodes == null || nodes.getLength() == 0) {
                LOGGER.debug("Found no nodes to replace");
                return xmlData;
            }
            LOGGER.debug("Found {} nodes to replace", (Object)nodes.getLength());
            IntStream.range(0, nodes.getLength()).mapToObj(i -> (Element)nodes.item(i)).forEach(v -> v.setAttribute(attributeName, attributeValue));
            Transformer transformer = this.transformerFactory.newTransformer();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            transformer.transform(new DOMSource(xmlDoc), new StreamResult(bos));
            return this.handleCompression(new BufferedInputStream(new ByteArrayInputStream(bos.toByteArray())), compression);
        }
        catch (XPathExpressionException e) {
            throw new ProcessingException(ToolBoxModuleErrorCode.ITM_XML_001, "Error evaluating XPath expression", (Throwable)e);
        }
        catch (TransformerException e) {
            throw new ProcessingException(ToolBoxModuleErrorCode.ITM_XML_001, "Error transforming XML", (Throwable)e);
        }
    }

    private InputStream handleDecompression(InputStream xmlData, Compression compression) throws IOException {
        if (compression == null) {
            return xmlData;
        }
        switch (compression) {
            case gzip: {
                return new GZIPInputStream(xmlData);
            }
            case deflate: {
                return new InflaterInputStream(xmlData, new Inflater());
            }
        }
        return xmlData;
    }

    private InputStream handleCompression(InputStream xmlData, Compression compression) throws IOException {
        if (compression == null) {
            return xmlData;
        }
        switch (compression) {
            case gzip: {
                int length;
                LOGGER.debug("Re-compressing data with {}", (Object)compression);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                GZIPOutputStream gos = new GZIPOutputStream(bos);
                byte[] bytes = new byte[1024];
                while ((length = xmlData.read(bytes)) != -1) {
                    gos.write(bytes, 0, length);
                }
                gos.flush();
                gos.close();
                byte[] gzippedBytes = bos.toByteArray();
                LOGGER.debug("GZipped length {}", (Object)gzippedBytes.length);
                ByteArrayInputStream bis = new ByteArrayInputStream(gzippedBytes);
                bos.close();
                return bis;
            }
            case deflate: {
                LOGGER.debug("Re-compressing data with {}", (Object)compression);
                return new DeflaterInputStream(xmlData, new Deflater());
            }
        }
        return xmlData;
    }

    private Compression getCompression(org.mule.extension.http.api.HttpResponseAttributes respAttrs) {
        if (respAttrs == null || respAttrs.getHeaders() == null) {
            return null;
        }
        String contentEncoding = (String)respAttrs.getHeaders().get((Object)"Content-Encoding");
        if (contentEncoding == null) {
            return null;
        }
        if (contentEncoding.contains(Compression.gzip.name())) {
            return Compression.gzip;
        }
        if (contentEncoding.contains(Compression.deflate.name())) {
            return Compression.deflate;
        }
        return null;
    }
}

