/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.itm.internal.operation;

import cz.integsoft.mule.itm.api.ToolBoxModuleErrorCode;
import cz.integsoft.mule.itm.api.exception.ProcessingException;
import cz.integsoft.mule.itm.api.http.Compression;
import cz.integsoft.mule.itm.api.xml.NamespaceDirectory;
import cz.integsoft.mule.itm.api.xml.NamespaceMapping;
import cz.integsoft.mule.itm.internal.error.GenericErrorTypeProvider;
import cz.integsoft.mule.itm.internal.parameter.XmlReplaceParameters;
import cz.integsoft.mule.itm.internal.xpath.XPathNamespaceContext;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Streaming;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlSupportOperation
implements Initialisable {
    private static final int BUFFER_SIZE = 1024;
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlSupportOperation.class);
    private DocumentBuilderFactory xmlDocFactory;
    private XPathFactory xpathFactory;
    private TransformerFactory transformerFactory;

    @Execution(value=ExecutionType.CPU_INTENSIVE)
    @Alias(value="xml-replace")
    @MediaType(value="*/*", strict=false)
    @Throws(value={GenericErrorTypeProvider.class})
    @Streaming
    public Result<InputStream, ?> xmlReplace(@ParameterGroup(name="XML Replacement Parameters") XmlReplaceParameters parameters, @Alias(value="attributes", description="Message attributes. Defaults to #[attributes]") @Optional(defaultValue="#[attributes]") Object attributes, @Content InputStream content, @Optional @NullSafe List<NamespaceMapping> namespaces, @Optional @ParameterDsl(allowInlineDefinition=false) @Alias(value="namespace-directory") NamespaceDirectory namespaceDirectory, StreamingHelper streamingHelper) {
        try {
            Result.Builder responseBuilder = Result.builder();
            String skipWhen = parameters.getSkipWhen();
            if (StringUtils.isNotBlank((CharSequence)skipWhen) && Boolean.parseBoolean(skipWhen)) {
                LOGGER.debug("Skipping XML replacement");
                return responseBuilder.output((Object)content).attributes(attributes).build();
            }
            return responseBuilder.output((Object)this.replaceInXml(parameters, content, attributes, this.mergeNamespaces(namespaces, namespaceDirectory))).attributes(attributes).build();
        }
        catch (Exception e) {
            throw new ProcessingException(ToolBoxModuleErrorCode.ITM_XML_002, (Throwable)e);
        }
    }

    public void initialise() throws InitialisationException {
        try {
            this.xmlDocFactory = DocumentBuilderFactory.newInstance();
            this.xmlDocFactory.setNamespaceAware(true);
            this.xmlDocFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            this.xmlDocFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            this.xpathFactory = XPathFactory.newInstance();
            this.transformerFactory = TransformerFactory.newInstance();
            this.transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    private InputStream replaceInXml(XmlReplaceParameters parameters, InputStream xmlData, Object attrs, Set<NamespaceMapping> namespaces) throws ProcessingException, IOException {
        Compression compression = this.getCompression(attrs);
        LOGGER.debug("Determined compression: {}", (Object)compression);
        Document xmlDoc = null;
        byte[] xmlCopy = IOUtils.toByteArray((InputStream)xmlData);
        try {
            xmlDoc = this.xmlDocFactory.newDocumentBuilder().parse(this.handleDecompression(new BufferedInputStream(new ByteArrayInputStream(xmlCopy)), compression));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOGGER.warn("Failed to parse XML document. Most likely it is not XML document at all. Ignoring this exception and returning the original data.", (Throwable)e);
            return this.toBufferedStream(xmlCopy);
        }
        try {
            XPath xpath = this.xpathFactory.newXPath();
            xpath.setNamespaceContext(new XPathNamespaceContext(namespaces.stream().collect(Collectors.toMap(ns -> ns.getPrefix(), ns -> ns.getUri()))));
            XPathExpression expression = xpath.compile(parameters.getXpath());
            NodeList nodes = (NodeList)expression.evaluate(xmlDoc, XPathConstants.NODESET);
            if (nodes == null || nodes.getLength() == 0) {
                LOGGER.debug("Found no nodes to replace");
                return this.toBufferedStream(xmlCopy);
            }
            LOGGER.debug("Found {} nodes to replace", (Object)nodes.getLength());
            IntStream.range(0, nodes.getLength()).mapToObj(i -> nodes.item(i)).forEach(v -> v.setNodeValue(parameters.getReplacementValue()));
            Transformer transformer = this.transformerFactory.newTransformer();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            transformer.transform(new DOMSource(xmlDoc), new StreamResult(bos));
            return this.handleCompression(this.toBufferedStream(bos.toByteArray()), compression);
        }
        catch (XPathExpressionException e) {
            throw new ProcessingException(ToolBoxModuleErrorCode.ITM_XML_001, "Error evaluating XPath expression", (Throwable)e);
        }
        catch (TransformerException e) {
            throw new ProcessingException(ToolBoxModuleErrorCode.ITM_XML_001, "Error transforming XML", (Throwable)e);
        }
    }

    private InputStream handleDecompression(InputStream xmlData, Compression compression) throws IOException {
        if (compression == null) {
            return xmlData;
        }
        switch (compression) {
            case gzip: {
                return new GZIPInputStream(xmlData);
            }
            case deflate: {
                return new InflaterInputStream(xmlData, new Inflater());
            }
        }
        return xmlData;
    }

    private InputStream handleCompression(InputStream xmlData, Compression compression) throws IOException {
        if (compression == null) {
            return xmlData;
        }
        switch (compression) {
            case gzip: {
                int length;
                LOGGER.debug("Re-compressing data with {}", (Object)compression);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                GZIPOutputStream gos = new GZIPOutputStream(bos);
                byte[] bytes = new byte[1024];
                while ((length = xmlData.read(bytes)) != -1) {
                    gos.write(bytes, 0, length);
                }
                gos.flush();
                gos.close();
                byte[] gzippedBytes = bos.toByteArray();
                LOGGER.debug("GZipped length {}", (Object)gzippedBytes.length);
                ByteArrayInputStream bis = new ByteArrayInputStream(gzippedBytes);
                bos.close();
                return bis;
            }
            case deflate: {
                LOGGER.debug("Re-compressing data with {}", (Object)compression);
                return new DeflaterInputStream(xmlData, new Deflater());
            }
        }
        return xmlData;
    }

    private Compression getCompression(Object attrs) {
        if (attrs == null || !this.isHttpResponse(attrs)) {
            return null;
        }
        if (((HttpResponseAttributes)attrs).getHeaders() == null) {
            return null;
        }
        if (this.isHttpResponse(attrs)) {
            String contentEncoding = (String)((HttpResponseAttributes)attrs).getHeaders().get((Object)"Content-Encoding");
            if (contentEncoding == null) {
                return null;
            }
            if (contentEncoding.contains(Compression.gzip.name())) {
                return Compression.gzip;
            }
            if (contentEncoding.contains(Compression.deflate.name())) {
                return Compression.deflate;
            }
        }
        return null;
    }

    private boolean isHttpResponse(Object attrs) {
        return attrs instanceof HttpResponseAttributes;
    }

    private InputStream toBufferedStream(byte[] data) {
        return new BufferedInputStream(new ByteArrayInputStream(data));
    }

    private Set<NamespaceMapping> mergeNamespaces(List<NamespaceMapping> namespaces, NamespaceDirectory directory) {
        HashSet<NamespaceMapping> merge = new HashSet<NamespaceMapping>();
        if (namespaces != null) {
            merge.addAll(namespaces);
        }
        if (directory != null && directory.getNamespaces() != null) {
            merge.addAll(directory.getNamespaces());
        }
        return merge;
    }
}

